## VA FitHeart Web Application

The VA FitHeart mobile application (app) is designed to help Veterans with heart conditions improve their heart health by increasing physical fitness and providing tools for a healthy lifestyle. The main part of the app’s program resembles a cardiac rehabilitation program, which guides people through education and fitness training over 12 weeks.
## Dependencies
* [Shared Services](https://wiki.mobilehealth.DOMAIN.EXT/pages/viewpage.action?title=Next+Gen+Shared+Services&spaceKey=VAMFAT): API Gateway, User Services, WAYF, ROA
* [vamf-notification-services](https://wiki.mobilehealth.DOMAIN.EXT/display/VDMS/Notification+Services):  allows creation, retrieval, updating of reminders and notifications
* [vamf-quartz-scheduler](https://wiki.mobilehealth.DOMAIN.EXT/display/VDMS/Notification+Services): supports Notification Services, creates scheduled jobs to fire in-app and email notifiactions
* [PGD FHIR Services](https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/PGD-FHIR+Server+Home):
	* FHIR Services
	* CCDA Server
	* Elasticsearch
	* MongoDB v3
	* Mongo Connector

## Local Setup
### Prerequisites

* clone the new-configuration branch of [NextGen-Stack repository](https://URL                  .DOMAIN.EXT/projects/VAMF/repos/nextgen-stack/browse)
* Follow README of above repository for basic environment prerequisites
* Update the category variables in **set-dev-envars.sh** to the following:

```bash
VET_MODE=true
STAFF_MODE=false
PGD_FHIR=true
```

**NOTE:** Please refer to the README in the above repository to resolve issues with deploying the PGD_FHIR services.

* Bring up nextgen-stack environment with `./run-all.sh`

### First Time Setup

To easily bring up all required containers for VA FitHeart for the first time, run the following from the applications root folder:

```bash
./nextgen/run-dev.sh
```

###  Setup for Developers with debugging and other Development Stack tools provided from the MAP Sustainment Team

Clone the developer's Nextgen Stack (MAP Sustainment) Repo which contains features taken from the Domino Local Development stack plus additional tools specific for debugging this Application.


[https://URL                  .DOMAIN.EXT/projects/MAPS/repos/cardiac-rehab-pro---local-development/browse]

git clone --branch testing/1.0 https://norcrossl@URL                  .DOMAIN.EXT/scm/maps/cardiac-rehab-pro---local-development.git



### Verification
If the application is setup correctly in the local NextGen Stack environment, you should be able to access the application at:
http://localhost:PORT/fit-heart/

### Redeploying
After making a change to the code, the following steps can be followed to redeploy the fit-heart-web image:

From the application root folder:

```bash
./nextgen/build.sh

```
